#include "default_icons.h"

#include <QIcon>

#include "coreinterface.h"
#include "settingsmanagerinterface.h"

/******************************************************************************
    DefaultIcons - public methods
******************************************************************************/

DefaultIcons::DefaultIcons(CoreInterface* coreIn, QObject* parent)
    : QObject(parent)
{
    core = coreIn;

    createIcons();
}

DefaultIcons::~DefaultIcons()
{
}

/******************************************************************************
    DefaultIcons - private methods
******************************************************************************/

void DefaultIcons::createIcons()
{
    core->settingsManager->setProperty("Temporary", "Icon.TuPP", QIcon(":/images/logo_128x128.png"));

    core->settingsManager->setProperty("Temporary", "Icon.NoAction", QIcon(":/images/noaction.png"));

    core->settingsManager->setProperty("Temporary", "Icon.Arrow.Down",  QIcon(":/images/arrow_down.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Arrow.Left",  QIcon(":/images/arrow_left.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Arrow.Right", QIcon(":/images/arrow_right.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Arrow.Up",    QIcon(":/images/arrow_up.png"));

    core->settingsManager->setProperty("Temporary", "Icon.File.Load",   QIcon(":/images/file_load.png"));
    core->settingsManager->setProperty("Temporary", "Icon.File.Save",   QIcon(":/images/file_save.png"));
    core->settingsManager->setProperty("Temporary", "Icon.File.SaveAs", QIcon(":/images/file_saveas.png"));
    core->settingsManager->setProperty("Temporary", "Icon.File.Reload", QIcon(":/images/file_reload.png"));
    core->settingsManager->setProperty("Temporary", "Icon.File.Exit",   QIcon(":/images/file_exit.png"));

    core->settingsManager->setProperty("Temporary", "Icon.Tools.Settings", QIcon(":/images/tools_settings.png"));

    core->settingsManager->setProperty("Temporary", "Icon.Help.Help",             QIcon(":/images/help_help.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Help.AboutApplication", QIcon(":/images/logo_128x128.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Help.AboutQt",          QIcon(":/images/help_aboutqt.png"));

    core->settingsManager->setProperty("Temporary", "Icon.Programmer.BlankCheck",   QIcon(":/images/programmer_blank_check.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.ChipInfo",     QIcon(":/images/programmer_chip_info.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.Erase",        QIcon(":/images/programmer_erase.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.Lock",         QIcon(":/images/programmer_lock.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.Program",      QIcon(":/images/programmer_program.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.ReadAll",      QIcon(":/images/programmer_read_all.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.ReadEeprom",   QIcon(":/images/programmer_read_eeprom.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.ReadFlash",    QIcon(":/images/programmer_read_flash.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.Reset",        QIcon(":/images/programmer_reset.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.VerifyAll",    QIcon(":/images/programmer_verify_all.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.VerifyEeprom", QIcon(":/images/programmer_verify_eeprom.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.VerifyFlash",  QIcon(":/images/programmer_verify_flash.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.WriteAll",     QIcon(":/images/programmer_write_all.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.WriteEeprom",  QIcon(":/images/programmer_write_eeprom.png"));
    core->settingsManager->setProperty("Temporary", "Icon.Programmer.WriteFlash",   QIcon(":/images/programmer_write_flash.png"));

    //Add all icons here
}
