#ifndef DEFAULT_ICONS_PLUGIN_H
#define DEFAULT_ICONS_PLUGIN_H

#include "plugininterface.h"
#include "pluginsloadingorder.h"

struct CoreInterface;
class DefaultIcons;

class DefaultIconsPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)

public:
    explicit DefaultIconsPlugin(QObject* parent = NULL);
    virtual ~DefaultIconsPlugin();

    void plug(CoreInterface* core);
    bool activate()                 { return true; } //Plugin doesn't have any GUI items
    bool deactivate()               { return false; } //Plugin cannot be deactivated

    QString name() const            { return "Default Icons"; }
    QString version() const         { return TUPP_VERSION; }
    QString description() const     { return "Plugin contains default icon set for application."; }
    QString authors() const         { return "Tomáš Hanák <tomas.hanak@gmail.com>"; }
    int loadOrder() const           { return ORDER_DEFAULT_ICONS; }
    bool isProgrammerPlugin() const { return false; } //Plugin isn't programmer plugin

    bool supportedChipsTable(QTableWidget*, QString*) { return false; } //Plugin isn't programmer plugin

    void settings()                 { } //Plugin doesn't have settings dialog

    void restoreSettings()          { } //Plugin doesn't have any GUI items - nothing to restore
    void saveSettings()             { } //Plugin doesn't have any GUI items - nothing to save

private:
    QPointer<DefaultIcons> m_DefaultIcons;
};

#endif //DEFAULT_ICONS_PLUGIN_H
