bool PluginManager::loadPlugin(const QString& name)
{
    QPluginLoader loader(name);
    QPointer<QObject> pluginObject = loader.instance();
    if (pluginObject)
    {
        PluginInterface* plugin = qobject_cast<PluginInterface*>(pluginObject);
        if (plugin)
        {
            qDebug() << "  Loading plugin" << plugin->name();

            for (int n = 0; n < pluginCount(); ++n)
            {
                if (this->plugin(n) == plugin)
                {
                    qWarning() << "    This plugin is already loaded (" << FileInfo(name).fileName() << ")";
                    return false; //Don't load plugin twice!
                }
                if (this->plugin(n)->name() == plugin->name())
                {
                    qWarning() << "    Plugin with the name" << plugin->name() << "is already loaded (from file" << FileInfo(d->m_PluginRecords[n].fullFileName).fileName() << ")";
                    qWarning() << "    Loading plugin" << FileInfo(name).fileName() << "has been skipped";
                    return false; //Don't load plugin twice!
                }
            }

            PluginRec newPluginRec;
            QString baseName = FileInfo(name).baseName();
#ifndef Q_WS_WIN
            baseName = baseName.mid(3); //Remove prefix 'lib'
#endif

            newPluginRec.plugin = plugin;
            newPluginRec.fullFileName   = name;
            newPluginRec.translator     = NULL; //Filled later
            newPluginRec.actionSelect   = NULL; //Filled later
            newPluginRec.actionSettings = NULL; //Filled later

            d->m_PluginRecords << newPluginRec;
            return true;
        }
        else
        {
            qWarning() << "  File is not valid TuPP plugin (" << FileInfo(name).fileName() << ")";
        }
    }
    else
    {
#ifndef Q_WS_WIN
        if (FileInfo(name).suffix() == "so")
#else
        if (FileInfo(name).suffix() == "dll")
#endif
        {
            qWarning() << "  Unable to load plugin:" << FileInfo(name).fileName() << loader.errorString();
        }
    }
    return false;
}
